#ifndef __CTextLabel__
#define __CTextLabel__

#include "CControl.hpp"
#include "../Fonts/CFont.hpp"

//	===========================================================================

using Exponent::GUI::Controls::CControl;
using Exponent::GUI::Fonts::CFont;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CTextLabel CTextLabel.hpp
			 * @brief Displays text in a box area
			 *
			 * @date 12/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CTextLabel.hpp,v 1.7 2007/02/08 21:07:54 paul Exp $
			 */
			class CTextLabel : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param text The text to display
				 */
				CTextLabel(IControlRoot *root, const long uniqueId, const CRect &area, const CString &text);

				/**
				 * Destruction
				 */
				virtual ~CTextLabel();

//	===========================================================================

				/**
				 * Set the colours to use
				 * @param frameColour The colour of the frame
				 * @param backgroundColour The background colour of the control
				 * @param textColour The colour of the text
				 */
				virtual void setColours(const CAlphaColour &frameColour = CAlphaColour::CALPHACOLOUR_BLACK, const CAlphaColour &backgroundColour = CAlphaColour::CALPHACOLOUR_WHITE, const CAlphaColour &textColour = CAlphaColour::CALPHACOLOUR_BLACK);

				/**
				 * Set the text colour
				 * @param textColour The colour of the text
				 */
				virtual void setTextColour(const CAlphaColour &textColour);

				/**
				 * Should we draw the frame
				 * @param draw If true then the fram and background will be drawn, if false then nothing except the string and the background image is draw (if applicable)
				 */
				virtual void drawFrameAndBackground(const bool draw = true) { m_drawFrameAndBackground = draw; }

				/**
				 * Set the font
				 * @param font The font to use
				 */
				virtual void setFont(CFont *font);

				/**
				 * Set the text
				 * @param text The string to display
				 */
				virtual void setText(const CString &text);

				/**
				 * Get the text
				 * @retval const CString & The text
				 */
				const CString &getText() const { return m_text; }

				/**
				 * Set the format to draw with
				 * @param format The text format to draw with
				 * @see CGraphics
				 */
				virtual void setTextFormat(const CGraphics::ETextAlignment format);

//	===========================================================================

				/**
				 * Draw the controls
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

				/**
				 * Handle an object being dropped
				 * @param event The drop event to handle
				 */
				virtual void handleFileDrop(const CDropEvent &event);

//	===========================================================================

			protected:

//	===========================================================================

				bool m_drawFrameAndBackground;				/**< Should we draw the frame and the background? */
				CFont *m_font;								/**< The font to draw with */
				CAlphaColour m_textColour;					/**< The colour of the text */
				CString m_text;								/**< The text to display */

				CGraphics::ETextAlignment m_textFormat;		/**< Format to draw the text */
			};
		}
	}
}
#endif	// End of CTextLabel.hpp